/*
  ==============================================================================

    SonicCrypt Flux Gate
    Copyright (C) 2025 Sebastian Sünkler

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.

  ==============================================================================
*/

#pragma once
#include <vector>
#include <cmath>
#include <algorithm>

class FluxEngine
{
public:
    static std::vector<float> generateEuclidean(int steps, int pulses, int rotation)
    {
        std::vector<float> pattern(steps, 0.0f);

        if (steps <= 0) return pattern;
        if (pulses <= 0) return pattern;

        if (pulses >= steps) {
            std::fill(pattern.begin(), pattern.end(), 1.0f);
            return pattern;
        }

        // Bresenham-Algorithmus für gleichmäßige Verteilung
        double slope = (double)pulses / (double)steps;
        double current = 0.0;

        for (int i = 0; i < steps; ++i) {
            double next = current + slope;
            // Wenn die Integer-Grenze überschritten wird, setzen wir einen Hit
            if ((int)next > (int)current) {
                pattern[i] = 1.0f;
            }
            current = next;
        }

        // Rotation (Offset) anwenden
        if (rotation != 0) {
            int r = rotation % steps;
            if (r < 0) r += steps;
            std::rotate(pattern.begin(), pattern.end() - r, pattern.end());
        }

        return pattern;
    }
};